﻿using AZVIC.Ei8htPOS.POSRetail.Helpers;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace AZVIC.Ei8htPOS.POSRetail.Pages
{
    /// <summary>
    /// Interaction logic for Reports.xaml
    /// </summary>
    public partial class Reports : Page
    {
        private enum ReportType { Stock, Customer, Sales };

        #region Constructor
        public Reports()
        {
            InitializeComponent();
            //LoadReports(ReportType.Stock);

        }
        #endregion

        private void NavigateFrame(Page pageName)
        {
            Frame ReportFrame = this.FindName("frmReports") as Frame;
            ReportFrame.Navigate(pageName);
        }
       
        private void btnLowStock_Click_1(object sender, RoutedEventArgs e)
        {
            NavigateFrame(new LowStockReport());
        }

        private void btnBestSellers_Click_1(object sender, RoutedEventArgs e)
        {
            NavigateFrame(new BestSellerReport());
        }

        private void btnProductsNever_Click_1(object sender, RoutedEventArgs e)
        {
            NavigateFrame(new ProductsNeverPurchasedReport());
        }

        private void btnCustomerTotals_Click_1(object sender, RoutedEventArgs e)
        {
            NavigateFrame(new TopCustomerOrdTotalReport());
        }

        private void btnCustomerOrders_Click_1(object sender, RoutedEventArgs e)
        {
            NavigateFrame(new TopCustomerNumberOfOrderReport());
        }

        private void btnRegisteredCustomers_Click_1(object sender, RoutedEventArgs e)
        {
            NavigateFrame(new RegisteredCustomers());
        }

        private void btnSalesMovement_Click_1(object sender, RoutedEventArgs e)
        {
            NavigateFrame(new SalesMovementReport());
        }

        private void btnSalesReport_Click_1(object sender, RoutedEventArgs e)
        {
            NavigateFrame(new SalesReport());
        }

        private void btnDailySalesReport_Click_1(object sender, RoutedEventArgs e)
        {
            NavigateFrame(new DailySalesReport());
        }

        private void btnMasterSalesReport_Click_1(object sender, RoutedEventArgs e)
        {
            NavigateFrame(new MasterSalesReport());
        }


    }
}
